<?php
/**
 * SKT Restaurant functions and definitions
 *
 * @package SKT Restaurant
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */
function content($limit) {
$content = explode(' ', get_the_excerpt(), $limit);
if (count($content)>=$limit) {
array_pop($content);
$content = implode(" ",$content).'...';
} else {
$content = implode(" ",$content);
}	
$content = preg_replace('/\[.+\]/','', $content);
$content = apply_filters('the_content', $content);
$content = str_replace(']]>', ']]&gt;', $content);
return $content;
}

function custom_excerpt_length( $length ) {
	return 100;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );


if ( ! function_exists( 'skt_restaurant_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */
function skt_restaurant_setup() {

	if ( ! isset( $content_width ) )
		$content_width = 640; /* pixels */

	load_theme_textdomain( 'skt-restaurant', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'title-tag' );
	add_image_size('homepage-thumb',240,145,true);
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'skt-restaurant' ),
		'footer' => __( 'Footer Menu', 'skt-restaurant' ),
	) );
	add_theme_support( 'custom-background', array(
		'default-color' => 'ffffff'
	) );
	add_editor_style( 'editor-style.css' );
}
endif; // skt_restaurant_setup
add_action( 'after_setup_theme', 'skt_restaurant_setup' );

function skt_restaurant_widgets_init() {

	register_sidebar( array(
		'name'          => __( 'Sidebar Main', 'skt-restaurant' ),
		'description'   => __( 'Appears on page sidebar', 'skt-restaurant' ),
		'id'            => 'sidebar-main',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'skt-restaurant' ),
		'description'   => __( 'Appears on blog page sidebar', 'skt-restaurant' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Footer Widget 1', 'skt-restaurant' ),
		'description'   => __( 'Appears on footer', 'skt-restaurant' ),
		'id'            => 'footer-1',
		'before_widget' => '<div id="%1$s" class="cols-4 widget-column-1">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2>',
		'after_title'   => '</h2>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Footer Widget 2', 'skt-restaurant' ),
		'description'   => __( 'Appears on footer', 'skt-restaurant' ),
		'id'            => 'footer-2',
		'before_widget' => '<div id="%1$s" class="cols-4 widget-column-2">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2>',
		'after_title'   => '</h2>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Footer Widget 3', 'skt-restaurant' ),
		'description'   => __( 'Appears on footer', 'skt-restaurant' ),
		'id'            => 'footer-3',
		'before_widget' => '<div id="%1$s" class="cols-4 widget-column-3">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2>',
		'after_title'   => '</h2>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Footer Widget 4', 'skt-restaurant' ),
		'description'   => __( 'Appears on footer', 'skt-restaurant' ),
		'id'            => 'footer-4',
		'before_widget' => '<div id="%1$s" class="cols-4 widget-column-4">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2>',
		'after_title'   => '</h2>',
	) );	

}
add_action( 'widgets_init', 'skt_restaurant_widgets_init' );

define( 'OPTIONS_FRAMEWORK_DIRECTORY', get_template_directory_uri() . '/inc/' );
require_once get_template_directory() . '/inc/options-framework.php';

function skt_restaurant_scripts() {
	wp_enqueue_style( 'skt_restaurant-gfonts-opensans', '//fonts.googleapis.com/css?family=Open+Sans:400,600,700' );
	wp_enqueue_style( 'skt_restaurant-gfonts-roboto', '//fonts.googleapis.com/css?family=Roboto:400,100,300,500,700' );
	wp_enqueue_style( 'skt_restaurant-gfonts-lobster', '//fonts.googleapis.com/css?family=Lobster' );
	wp_enqueue_style( 'skt_restaurant-gfonts-opensanscondensed', '//fonts.googleapis.com/css?family=Open+Sans+Condensed:300' );
	wp_enqueue_style( 'skt_restaurant-gfonts-lato', '//fonts.googleapis.com/css?family=Lato:400,900,400italic,700,300italic,300,700italic' );

	if( of_get_option('bodyfontface',true) != '' ){
		wp_enqueue_style( 'skt_restaurant-gfonts-body', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('bodyfontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin');
	}
	if( of_get_option('logofontface',true) != '' ){
		wp_enqueue_style( 'skt_restaurant-gfonts-logo', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('logofontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin');
	}
	if ( of_get_option('navfontface', true) != '' ) {
		wp_enqueue_style( 'skt_restaurant-gfonts-nav', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('navfontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin');
	}
	if ( of_get_option('headfontface', true) != '' ) {
		wp_enqueue_style( 'skt_restaurant-gfonts-heading', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('headfontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin');
	}
	

	wp_enqueue_style( 'skt_restaurant-basic-style', get_stylesheet_uri() );
	wp_enqueue_style( 'skt_restaurant-editor-style', get_template_directory_uri().'/editor-style.css' );
	wp_enqueue_style( 'skt_restaurant-base-style', get_template_directory_uri().'/css/style_base.css' );
	
	//if ( is_home() || is_front_page() ) { 
	wp_enqueue_style( 'skt_restaurant-nivo-style', get_template_directory_uri().'/css/nivo-slider.css' );
	wp_enqueue_script( 'skt_restaurant-nivo-slider', get_template_directory_uri() . '/js/jquery.nivo.slider.js', array('jquery') );
	//}	
	wp_enqueue_style( 'skt_restaurant-prettyphoto-style', get_template_directory_uri().'/css/prettyPhoto.css' );
	wp_enqueue_script( 'skt_restaurant-prettyphoto-script', get_template_directory_uri() . '/js/jquery.prettyPhoto.js', array('jquery') );
	wp_enqueue_script( 'skt_restaurant-customscripts', get_template_directory_uri() . '/js/custom.js', array('jquery') );
	wp_enqueue_style( 'skt_restaurant-font-awesome-style', get_template_directory_uri().'/css/font-awesome.css' );	
	wp_enqueue_script( 'skt_restaurant-testimonialsminjs', get_template_directory_uri().'/testimonials-rotator/js/jquery.quovolver.min.js' );
	wp_enqueue_script( 'skt_restaurant-testimonials-bootstrap', get_template_directory_uri().'/testimonials-rotator/js/bootstrap.js' );
	wp_enqueue_style( 'skt_restaurant-testimonialslider-style', get_template_directory_uri().'/testimonials-rotator/js/tm-rotator.css' );		
	wp_enqueue_style( 'skt_restaurant-animation-style', get_template_directory_uri().'/css/animation.css' );
	wp_enqueue_style( 'skt_restaurant-responsive-style', get_template_directory_uri().'/css/theme-responsive.css' );
	
	// mixitup gallery
	wp_enqueue_style( 'skt_restaurant-mixitup-style', get_template_directory_uri().'/mixitup/demo.css' );
	wp_enqueue_script( 'skt_restaurant-mixitup-scripts', get_template_directory_uri().'/mixitup/jquery_mixitup.js' );
	
	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'skt_restaurant_scripts' );

function media_css_hook(){
	
	?>
    	
    	<script>
			jQuery(window).bind('scroll', function() {
	var wwd = jQuery(window).width();
	if( wwd > 939 ){
		var navHeight = jQuery( window ).height() - 0;
		<?php if( of_get_option('headstick',true) != true) { ?>
		if (jQuery(window).scrollTop() > navHeight) {
			jQuery(".header").addClass('fixed');
		}else {
			jQuery(".header").removeClass('fixed');
		}
		<?php } ?>
	}
});
		jQuery(document).ready(function() {
        jQuery('#slider').nivoSlider({
        	effect:'<?php echo of_get_option('slideefect',true); ?>', //sliceDown, sliceDownLeft, sliceUp, sliceUpLeft, sliceUpDown, sliceUpDownLeft, fold, fade, random, slideInRight, slideInLeft, boxRandom, boxRain, boxRainReverse, boxRainGrow, boxRainGrowReverse
		  	animSpeed: <?php echo of_get_option('slideanim',true); ?>,
			pauseTime: <?php echo of_get_option('slidepause',true); ?>,
			directionNav: <?php echo of_get_option('slidenav',true); ?>,
			controlNav: <?php echo of_get_option('slidepage',true); ?>,
			pauseOnHover: <?php echo of_get_option('slidepausehover',true); ?>,
    });
});


jQuery(document).ready(function() {
  
  jQuery('.link').on('click', function(event){
    var $this = jQuery(this);
    if($this.hasClass('clicked')){
      $this.removeAttr('style').removeClass('clicked');
    } else{
      $this.css('background','#7fc242').addClass('clicked');
    }
  });
 
});
		</script>
<?php 
}
add_action('wp_head','media_css_hook'); 


function skt_restaurant_custom_head_codes() { 
	if ( function_exists('of_get_option') ){
		if ( of_get_option('style2', true) != '' ) {
			echo "<style>". esc_html( of_get_option('style2', true) ) ."</style>";
		}
		echo "<style>";
		if ( of_get_option('bodyfontface', true) != '') {
			echo 'body, .feature-box p, .address, .price-table{font-family:\''. esc_html( of_get_option('bodyfontface', true) ) .'\', sans-serif;}';
		}
		if ( of_get_option('bodyfontcolor', true) != '' ) {
			echo 'body, .contact-form-section .address,  .accordion-box .acc-content{color:'. esc_html( of_get_option('bodyfontcolor', true) ) .';}';
		}
		if( of_get_option('bodyfontsize',true) != ''){
			echo "body{font-size:".of_get_option('bodyfontsize',true)."}";
		}
		if( of_get_option('logofontface',true) != '' || of_get_option('logofontcolor',true) != '' || of_get_option('logofontsize',true) != ''){
			echo ".header .header-inner .logo h1, .logo a{font-family:".of_get_option('logofontface').";color:".of_get_option('logofontcolor',true).";font-size:".of_get_option('logofontsize',true)."}";
		}
		if( of_get_option('logofontcolor',true) != '' ){
			echo ".header span.tagline{color:".of_get_option('logofontcolor',true).";}";
		}
		
		if ( of_get_option('navfontface', true) != '' || of_get_option('navfontsize',true) != '' ) {
			echo '.sitenav ul{font-family:\''. esc_html( of_get_option('navfontface', true) ) .'\', sans-serif;font-size:'.of_get_option('navfontsize',true).'}';
		}
		if ( of_get_option('navfontcolor', true) != '' ) {
			echo '.sitenav ul li a, .sitenav ul li ul li a{color:'. esc_html( of_get_option('navfontcolor', true) ) .';}';
		}
		if ( of_get_option('navhovercolor', true) != '' || of_get_option('navhoverborder', true) != '' ) {
			echo '.sitenav ul li a:hover, .sitenav ul li.current_page_item a{color:'. esc_html( of_get_option('navhovercolor', true) ) .'; border-color:'. esc_html( of_get_option('navhoverborder', true) ) .';}';
		}
				
					
		if( of_get_option('spbxtitle',true) != '' || of_get_option('spclbxtitle', true) != '' ){
			echo "#todayspecial-box h2{font-size:".of_get_option('spbxtitle',true)."; color:". esc_html( of_get_option('spclbxtitle', true) ) .";}";
		}			
		if( of_get_option('sectitlesize',true) != '' ){
			echo "h2.sectiontitle{font-size:".of_get_option('sectitlesize',true)."}";
		}		
		if ( of_get_option('headfontface', true) != '' || of_get_option('sectitlecolor',true) != '' ) {
			echo 'h1, h2, h3, h4, h5, h6, section h1, .news h2, .testimonial-box h2, .team-col h3{font-family:\''. esc_html( of_get_option('headfontface', true) ) .'\', sans-serif;color:'.of_get_option('sectitlecolor',true).'}';
		}				
		if ( of_get_option('spclhvbxtitle', true) != '' ) {
			echo '#todayspecial-box:hover h2{color:'. esc_html( of_get_option('spclhvbxtitle', true) ) .';}';
		}	
		if ( of_get_option('ourmenudesc', true) != '' ) {
			echo '.hmourmenu p{color:'. esc_html( of_get_option('ourmenudesc', true) ) .';}';
		}	
			
		if ( of_get_option('linkcolor', true) != '' ) {
			echo 'a{color:'. esc_html( of_get_option('linkcolor', true) ) .';}';
		}
		if ( of_get_option('linkhovercolor', true) != '' ) {
			echo 'a:hover{color:'. esc_html( of_get_option('linkhovercolor', true) ) .';}';
		}	
		
		if( of_get_option('foottitlecolor', true) != '' || of_get_option('ftfontsize', true) != '' || of_get_option('foottitleborder', true) != ''){
			echo ".cols-4 h2{color:".of_get_option('foottitlecolor', true)."; font-size:".of_get_option('ftfontsize', true)."; border-bottom:1px solid".of_get_option('foottitleborder', true)."; }";
		}
		if( of_get_option('hmmenutitle', true) != ''){
			echo ".hmourmenu .one_half h2{color:".of_get_option('hmmenutitle', true)."}";
		}
		
		if( of_get_option('footdesccolor', true) != '' || of_get_option('footerstyle', true) != ''){
			echo ".cols-4{color:".of_get_option('footdesccolor', true)."; font-style:".of_get_option('footerstyle',true).";}";
		}	
					
		if( of_get_option('copycolor', true) != ''){
			echo ".copyright-txt{color:".of_get_option('copycolor',true)."}";
		}
		if( of_get_option('designcolor', true) != ''){
			echo ".design-by{color:".of_get_option('designcolor',true)."}";
		}		
		
		$hdrhex = of_get_option('headerbg',true); 
		list($r,$g,$b) = sscanf($hdrhex,'#%02x%02x%02x');
		if ( of_get_option('headerbg', true) != '' ) {
			echo ".header-inner, .sitenav ul li:hover > ul{background-color:rgba(".$r.",".$g.",".$b.",".of_get_option('headerbgopacity',true).");}";
		}
	
		$twoboxhex = of_get_option('twoboxbg',true); 
		list($r,$g,$b) = sscanf($twoboxhex,'#%02x%02x%02x');
		if ( of_get_option('twoboxbg', true) != '' ) {
			echo ".officehour .one_half .commonbox{background-color:rgba(".$r.",".$g.",".$b.",".of_get_option('twoboxbgopacity',true).");}";
		}		
		if ( of_get_option('rohboxcolor', true) != '' || of_get_option('rohboxfontsize', true) != '') {
			echo '.officehour .one_half .commonbox{color:'. esc_html( of_get_option('rohboxcolor', true) ) .'; font-size:'. esc_html( of_get_option('rohboxfontsize', true) ) .'; }';
		}
							
			
		if( of_get_option('socialcolor',true) != '' ){
			echo ".social-icons a{border-color:".of_get_option('socialcolor',true)."; color:".of_get_option('socialcolor',true).";}";
		}
		if( of_get_option('socialhvcolor',true) != ''){
			echo ".social-icons a:hover{border-color:".of_get_option('socialhvcolor',true)."; color:".of_get_option('socialhvcolor',true)."; }";
		}		
		if( of_get_option('btncolor',true) != '' || of_get_option('btntxtcolor', true) != ''){
			echo ".button, #commentform input#submit, input.search-submit, .post-password-form input[type=submit], .pagination ul li .current, .pagination ul li a:hover{background-color:".of_get_option('btncolor',true)."; color:". of_get_option('btntxtcolor', true) ."; }";
		}
		if( of_get_option('btnhvcolor',true) != '' || of_get_option('btntxthvcolor', true) != ''){
			echo ".button:hover, #commentform input#submit:hover, input.search-submit:hover, .post-password-form input[type=submit]:hover, .pagination ul li span, .pagination ul li a{background-color:".of_get_option('btnhvcolor',true)."; color:". esc_html( of_get_option('btntxthvcolor', true) ) .";}";
		}					
		if ( of_get_option('wdgttitleccolor', true) != '' || of_get_option('wdgtbordercolor', true) != '') {
			echo "h3.widget-title{color:".of_get_option('wdgttitleccolor', true)."; border-bottom:1px solid ".of_get_option('wdgtbordercolor',true).";}";
		}
		if ( of_get_option('footerbgcolor', true) != '' || of_get_option('footerborder',true) != '' ) {
			echo "#footer-wrapper{background-color:".of_get_option('footerbgcolor', true)."; border-top:6px solid ".of_get_option('footerborder',true).";}";
		}			
		if ( of_get_option('footermenucolor', true) != '' || of_get_option('footerstyle', true) != '' ) {
			echo ".cols-4 ul li a{color:".of_get_option('footermenucolor', true)."; font-style:".of_get_option('footerstyle', true)."; }";
		}
		
		if ( of_get_option('footermenucurrent', true) != '' ) {
			echo ".cols-4 ul li a:hover, .cols-4 ul li.current_page_item a{color:".of_get_option('footermenucurrent', true)."; }";
		}
			
		if ( of_get_option('copybgcolor', true) != '' ) {
			echo '.copyright-wrapper{background-color:'. esc_html( of_get_option('copybgcolor', true) ) .';}';
		}
		if( of_get_option('galhvcolor',true) != ''){
			echo "#Grid .mix{ background:".of_get_option('galhvcolor',true)."; float:left; background:url(".get_template_directory_uri()."/images/camera-icon.png) 50% 0% no-repeat ".of_get_option('galhvcolor',true)."; }";
		}
				
		if( of_get_option('sldnavbg',true) != ''){
			echo ".nivo-directionNav a{background:url(".get_template_directory_uri()."/images/slide-nav.png) no-repeat scroll 0 0 ".of_get_option('sldnavbg',true).";}";
		}
		if( of_get_option('sldpagebg',true) != ''){
			echo ".nivo-controlNav a{background-color:".of_get_option('sldpagebg',true)."}";
		}
		if( of_get_option('sldpagehvbg',true) != ''){
			echo ".nivo-controlNav a.active{background-color:".of_get_option('sldpagehvbg',true)."}";
		}
		if( of_get_option('filterbgcolor',true) != '' || of_get_option('ourmenuhover',true) != ''){
			echo "#menulist ul#filter li.active{background-color:".of_get_option('filterbgcolor',true)."; color:".of_get_option('ourmenuhover',true)."}";
		}		
		if( of_get_option('sidebarfontcolor',true) != ''){
			echo "#sidebar ul li a{color:".of_get_option('sidebarfontcolor',true)."}";
		}
		
		if ( of_get_option('linkcolor', true) != '' ) {
			echo '#sidebar ul li a:hover{color:'. esc_html( of_get_option('linkcolor', true) ) .';}';
		}
		
		if( of_get_option('booknow',true) != '' || of_get_option('booknowfontcolor',true) != ''){
			echo ".button2{background-color:".of_get_option('booknow',true)."; color:".of_get_option('booknowfontcolor',true)."}";
		}
		
		if( of_get_option('ohborder',true) != '' ){
			echo ".time_table .time_row{border-bottom:1px solid".of_get_option('ohborder',true)."}";
		}
		
			
		if ( of_get_option('slidecaph2', true) != '' || of_get_option('slidetitlecolor', true) != '' || of_get_option('slidetitlefontsize', true) != '') {
		echo ".slide_info h2{background-color:".of_get_option('slidecaph2', true)."; color:".of_get_option('slidetitlecolor', true)."; font-size:".of_get_option('slidetitlefontsize', true).";}";
		}
		
		if ( of_get_option('slidecapdes', true) != '' || of_get_option('slidedesccolor', true) != '' || of_get_option('slidedescfontsize', true) != '') {
		echo ".slide_info .slide-desc{background-color:".of_get_option('slidecapdes', true)."; color:".of_get_option('slidedesccolor', true)."; font-size:".of_get_option('slidedescfontsize', true).";}";
		}
		
		$sliderhex = of_get_option('slidecaph2',true); 
		list($r,$g,$b) = sscanf($sliderhex,'#%02x%02x%02x');
		if ( of_get_option('slidecaph2', true) != '' ) {
			echo ".slide_info h2, .slide_info .slide-desc{background-color:rgba(".$r.",".$g.",".$b.",".of_get_option('slidecapopacity',true).");}";
		}		
		if( of_get_option('newsboxborder',true) != '' ){
			echo ".news-box, .news-box .news-content h2{border-color:".of_get_option('newsboxborder',true)."}";
		}	
			
		if( of_get_option('glfilterfontcolor',true) != ''){
			echo ".controls li{color:".of_get_option('glfilterfontcolor',true)."; }";
		}
		
		if( of_get_option('glfilterfontcolorhv',true) != ''){
			echo ".controls li.active, .controls li:hover{color:".of_get_option('glfilterfontcolorhv',true)."; }";
		}			
				
		if( of_get_option('togglecolor',true) != '' ){
			echo ".slide_toggle a, .accordion-box h2, .tabs-wrapper ul.tabs li a{color:".of_get_option('togglecolor',true)."}";
		}		
		if( of_get_option('toggleactive',true) != '' ){
			echo "h3.clicked a, .accordion-box h2.active, .tabs-wrapper ul.tabs li a.selected{color:".of_get_option('toggleactive',true)."}";
		}
		if( of_get_option('logoheight',true) != '' ){
			echo ".logo img{height:".of_get_option('logoheight',true)."px;}";
		}
		
		if( of_get_option('menubgonresponsive',true) != '' ){
			echo "@media screen and (max-width:767px) {
			      .sitenav{background-color:".of_get_option('menubgonresponsive',true).";}
			}";
		}		
		
		echo "</style>";
	}
}
add_action('wp_head', 'skt_restaurant_custom_head_codes');


function skt_restaurant_pagination() {
	global $wp_query;
	$big = 12345678;
	$page_format = paginate_links( array(
	    'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
	    'format' => '?paged=%#%',
	    'current' => max( 1, get_query_var('paged') ),
	    'total' => $wp_query->max_num_pages,
	    'type'  => 'array'
	) );
	if( is_array($page_format) ) {
		$paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');
		echo '<div class="pagination"><div><ul>';
		echo '<li><span>'. $paged . ' of ' . $wp_query->max_num_pages .'</span></li>';
		foreach ( $page_format as $page ) {
			echo "<li>$page</li>";
		}
		echo '</ul></div></div>';
	}
}
/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';


/**
 * Load custom functions file.
 */
require get_template_directory() . '/inc/custom-functions.php';



function skt_restaurant_custom_blogpost_pagination( $wp_query ){
	$big = 999999999; // need an unlikely integer
	if ( get_query_var('paged') ) { $pageVar = 'paged'; }
	elseif ( get_query_var('page') ) { $pageVar = 'page'; }
	else { $pageVar = 'paged'; }
	$pagin = paginate_links( array(
		'base' 			=> str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
		'format' 		=> '?'.$pageVar.'=%#%',
		'current' 		=> max( 1, get_query_var($pageVar) ),
		'total' 		=> $wp_query->max_num_pages,
		'prev_text'		=> '&laquo; Prev',
		'next_text' 	=> 'Next &raquo;',
		'type'  => 'array'
	) ); 
	if( is_array($pagin) ) {
		$paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');
		echo '<div class="pagination"><div><ul>';
		echo '<li><span>'. $paged . ' of ' . $wp_query->max_num_pages .'</span></li>';
		foreach ( $pagin as $page ) {
			echo "<li>$page</li>";
		}
		echo '</ul></div></div>';
	} 
}

// get slug by id
function skt_restaurant_get_slug_by_id($id) {
	$post_data = get_post($id, ARRAY_A);
	$slug = $post_data['post_name'];
	return $slug; 
}


// custom post type for testimonial
function my_custom_post_testimonial() {
	$labels = array(
		'name'               => __( 'Testimonial','skt-restaurant'),
		'singular_name'      => __( 'Testimonial','skt-restaurant'),
		'add_new'            => __( 'Add Testimonial','skt-restaurant'),
		'add_new_item'       => __( 'Add New Testimonial','skt-restaurant'),
		'edit_item'          => __( 'Edit Testimonial','skt-restaurant'),
		'new_item'           => __( 'New Testimonial','skt-restaurant'),
		'all_items'          => __( 'All Testimonials','skt-restaurant'),
		'view_item'          => __( 'View Testimonial','skt-restaurant'),
		'search_items'       => __( 'Search Testimonial','skt-restaurant'),
		'not_found'          => __( 'No Testimonial found','skt-restaurant'),
		'not_found_in_trash' => __( 'No Testimonial found in the Trash','skt-restaurant'), 
		'parent_item_colon'  => '',
		'menu_name'          => 'Testimonial'
	);
	$args = array(
		'labels'        => $labels,
		'description'   => 'Manage Testimonials',
		'public'        => true,
		'menu_icon'		=> 'dashicons-format-quote',
		'menu_position' => null,
		'supports'      => array( 'title', 'editor', 'thumbnail'),
		'has_archive'   => true,
	);
	register_post_type( 'testimonial', $args );	
}
add_action( 'init', 'my_custom_post_testimonial' );


// add shortcode for todays pecial
function skt_restaurant_todayspecial($skt_var, $content = null){
		extract( shortcode_atts(array(
			'title' => 'title',
			'icon'  => get_template_directory_uri().'/images/icon-customizable.png',
			'link'	=> '#',
		), $skt_var));
		
		return '<div id="todayspecial-box">
				<a href="'.$link.'"><img src="'.$icon.'" />
				<h2>'.$title.'</h2></a>
				</div>';
}
add_shortcode('todayspecial','skt_restaurant_todayspecial');